########## about #############
# Plot amplitude sweeps
# Two versions: with and without error bars
# sizes: 6.5 x 4.5
# 5.5 x 3.8 (smaller as in manuscript)

########### prelims #################
library(ggplot2)
library(latex2exp) # To use latex in plots
library(reshape2) # for reshaping my data into the long format.
library(scales)
library(MetBrewer)


########### color palettes ###############
### colorblind-friendly from https://jfly.uni-koeln.de/color/
# The palette with grey:
cbPalette <- c("#999999", "#E69F00", "#56B4E9", "#009E73", #"#F0E442", 
               "#0072B2", "#D55E00", "#CC79A7")

# The palette with black:
cbbPalette <- c("#000000", "#E69F00", "#56B4E9", "#009E73", #"#F0E442", 
                "#0072B2", "#D55E00", "#CC79A7")

# another palette with 15 colors (source: https://jacksonlab.agronomy.wisc.edu/2016/05/23/15-level-colorblind-friendly-palette/)
pal <- c("#000000","#004949","#009292","#ff6db6","#ffb6db",
         "#490092","#006ddb","#b66dff","#6db6ff","#b6dbff",
         "#920000","#924900","#db6d00","#24ff24","#ffff6d")
cbPalblue <- c("#f0f9e8", "#bae4bc", "#7bccc4", "#43a2ca","#0868ac")
cbPalblueyellow <- c("#ffffcc", "#a1dab4", "#41b6c4", "#2c7fb8","#253494")
cbPalVivid_correctorder <- c("#AF1B3F", "#F4A698", "#262626", "#6BAA75", "#255C99", "#7EA3CC")
cbPalVivid <- c("#AF1B3F", "#F4A698", "#255C99", "#7EA3CC", "#262626", "#6BAA75")
cm2inch <- 1/2.54

# To use for fills, add
# scale_fill_manual(values=cbPalette)

# To use for line and point colors, add
# scale_colour_manual(values=cbPalette)

################# Read data ################################################################
rheo_data <- read.csv(file="C:/Users/s168562/OneDrive - TU Eindhoven/PhD/2_HR_printing/Data_analysis/Rheology/Amplitude sweeps/CV-GNP5-PU9.csv", 
                      header=F, sep=",",dec=".",skip=5)
outfolder <- "C:/Users/s168562/OneDrive - TU Eindhoven/PhD/2_HR_printing/Data_analysis/Rheology/Amplitude sweeps/Figures/"




################ Prepare data for plotting | version for data measured in duplicate or more (avg/std) ######################################
rheo_df <- data.frame(shear_strain = rheo_data[,1],
                      shear_stress = rheo_data[,2],
                      storage_mod = rheo_data[,3],
                      loss_mod = rheo_data[,4],
                      loss_factor = rheo_data[,5]
)

rheo_sd_df <- data.frame(shear_strain = rheo_data[,1],
                         shear_stress = rheo_data[,6],
                         storage_mod = rheo_data[,7],
                         loss_mod = rheo_data[,8],
                         loss_factor = rheo_data[,9]
)

# Calculate min and max values for error bars
rheo_sd_df$storage_mod_min <- rheo_df$storage_mod - rheo_sd_df$storage_mod
rheo_sd_df$storage_mod_max <- rheo_df$storage_mod + rheo_sd_df$storage_mod
rheo_sd_df$loss_mod_min <- rheo_df$loss_mod - rheo_sd_df$loss_mod
rheo_sd_df$loss_mod_max <- rheo_df$loss_mod + rheo_sd_df$loss_mod
rheo_sd_df$loss_factor_min <- rheo_df$loss_factor - rheo_sd_df$loss_factor
rheo_sd_df$loss_factor_max <- rheo_df$loss_factor + rheo_sd_df$loss_factor

###############  Plotting | version with error bars for data measured with N >= 2 #########################################
figname <- "LH-PU23_amplitude_sweep"

## Plot tiff
tiff(paste(outfolder, figname, ".tiff", sep=""),
     width = 6.5, height = 4.5, units = "cm", compression = "lzw", res = 800, pointsize = 8, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_df, aes(x = 100*shear_strain, y = storage_mod, color = "G'", shape = "G'")) +
  geom_point(size = .75) + #geom_point(size = 3)
  geom_point(aes(x = 100*shear_strain, y = loss_mod, color = "G''", shape = "G''"), size = 0.75) +
  geom_errorbar(data = rheo_sd_df, aes(x = 100*shear_strain, ymin = storage_mod_min, ymax = storage_mod_max, color = "G'"), width = 0.025) +
  geom_errorbar(data = rheo_sd_df, aes(x = 100*shear_strain, ymin = loss_mod_min, ymax = loss_mod_max, color = "G''"), width = 0.025) +
  scale_x_log10(labels = c(0.01, 0.1, 1, 10, 100), breaks = c(0.01, 0.1, 1, 10, 100), limits = c(0.01, 100), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  scale_y_log10(labels = c(10, 100, 1000, 10000, "100000"), breaks = c(10, 100, 1000, 10000, 100000), limits = c(10, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  annotation_logticks(sides = "trbl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear strain \\[%\\]")) +
  ylab(TeX("G' G'' \\[Pa\\]")) +
  scale_shape_manual(values = c(19, 15, 17, 18, 21, 22, 23, 24, 25), 
                     name = "", # without the name argument in both scale types, there will be two legends (one for color, one for shape)
                     breaks = c("G'", "G''"),
                     labels = c("G'", "G''"))+ # guide = FALSE
  scale_colour_manual(values=cbPalVivid, 
                      name = "",
                      breaks = c("G'", "G''"),
                      labels = c("G'", "G''")) + # breaks are not required, otherwise it will just copy them from the color names
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

## Plot pdf
pdf(paste(outfolder, figname, ".pdf", sep=""),
    width = 6.5*cm2inch, height = 4.5*cm2inch)
viscosity_plot <-  ggplot(data = rheo_df, aes(x = 100*shear_strain, y = storage_mod, color = "G'", shape = "G'")) +
  geom_point(size = .75) + #geom_point(size = 3)
  geom_point(aes(x = 100*shear_strain, y = loss_mod, color = "G''", shape = "G''"), size = 0.75) +
  geom_errorbar(data = rheo_sd_df, aes(x = 100*shear_strain, ymin = storage_mod_min, ymax = storage_mod_max, color = "G'"), width = 0.025) +
  geom_errorbar(data = rheo_sd_df, aes(x = 100*shear_strain, ymin = loss_mod_min, ymax = loss_mod_max, color = "G''"), width = 0.025) +
  scale_x_log10(labels = c(0.01, 0.1, 1, 10, 100), breaks = c(0.01, 0.1, 1, 10, 100), limits = c(0.01, 100), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  scale_y_log10(labels = c(10, 100, 1000, 10000, "100000"), breaks = c(10, 100, 1000, 10000, 100000), limits = c(10, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  annotation_logticks(sides = "trbl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear strain \\[%\\]")) +
  ylab(TeX("G' G'' \\[Pa\\]")) +
  scale_shape_manual(values = c(19, 15, 17, 18, 21, 22, 23, 24, 25), 
                     name = "", # without the name argument in both scale types, there will be two legends (one for color, one for shape)
                     breaks = c("G'", "G''"),
                     labels = c("G'", "G''"))+ # guide = FALSE
  scale_colour_manual(values=cbPalVivid, 
                      name = "",
                      breaks = c("G'", "G''"),
                      labels = c("G'", "G''")) + # breaks are not required, otherwise it will just copy them from the color names
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

###############  Plotting loss factors | version with error bars for data measured with N >= 2 #########################################
figname <- "LH-PU23_loss_factor_amplitude_sweep"

## Plot tiff
tiff(paste(outfolder, figname, ".tiff", sep=""),
     width = 6.5, height = 4.5, units = "cm", compression = "lzw", res = 800, pointsize = 8, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_df, aes(x = 100*shear_strain, y = loss_factor, color = "G'", shape = "G'")) +
  geom_point(size = .75) + #geom_point(size = 3)
  geom_errorbar(data = rheo_sd_df, aes(x = 100*shear_strain, ymin = loss_factor_min, ymax = loss_factor_max, color = "G'"), width = 0.025) +
  scale_x_log10(labels = c(0.01, 0.1, 1, 10, 100), breaks = c(0.01, 0.1, 1, 10, 100), limits = c(0.01, 100), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(10, 100, 1000, 10000, "100000"), breaks = c(10, 100, 1000, 10000, 100000), limits = c(10, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  ylim(0, 5) +
  annotation_logticks(sides = "tb", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear strain \\[%\\]")) +
  ylab(TeX("Loss factor")) +
  scale_shape_manual(values = c(19, 15, 17, 18, 21, 22, 23, 24, 25), 
                     name = "", # without the name argument in both scale types, there will be two legends (one for color, one for shape)
                     breaks = c("G'", "G''"),
                     labels = c("G'", "G''"),
                     guide = FALSE)+ # guide = FALSE
  scale_colour_manual(values=cbPalVivid, 
                      name = "",
                      breaks = c("G'", "G''"),
                      labels = c("G'", "G''"),
                      guide = FALSE) + # breaks are not required, otherwise it will just copy them from the color names
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.25),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

## Plot pdf
pdf(paste(outfolder, figname, ".pdf", sep=""),
    width = 6.5*cm2inch, height = 4.5*cm2inch)
viscosity_plot <-  ggplot(data = rheo_df, aes(x = 100*shear_strain, y = loss_factor, color = "G'", shape = "G'")) +
  geom_point(size = .75) + #geom_point(size = 3)
  geom_errorbar(data = rheo_sd_df, aes(x = 100*shear_strain, ymin = loss_factor_min, ymax = loss_factor_max, color = "G'"), width = 0.025) +
  scale_x_log10(labels = c(0.01, 0.1, 1, 10, 100), breaks = c(0.01, 0.1, 1, 10, 100), limits = c(0.01, 100), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(10, 100, 1000, 10000, "100000"), breaks = c(10, 100, 1000, 10000, 100000), limits = c(10, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  ylim(0, 5) +
  annotation_logticks(sides = "tb", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear strain \\[%\\]")) +
  ylab(TeX("Loss factor")) +
  scale_shape_manual(values = c(19, 15, 17, 18, 21, 22, 23, 24, 25), 
                     name = "", # without the name argument in both scale types, there will be two legends (one for color, one for shape)
                     breaks = c("G'", "G''"),
                     labels = c("G'", "G''"),
                     guide = FALSE)+ # guide = FALSE
  scale_colour_manual(values=cbPalVivid, 
                      name = "",
                      breaks = c("G'", "G''"),
                      labels = c("G'", "G''"),
                      guide = FALSE) + # breaks are not required, otherwise it will just copy them from the color names
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.25),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

################ Prepare data for plotting | version without error bars ######################################
rheo_df <- data.frame(shear_strain = rheo_data[,1],
                      shear_stress = rheo_data[,2],
                      storage_mod = rheo_data[,3],
                      loss_mod = rheo_data[,4],
                      loss_factor = rheo_data[,5]
)


###############  Plotting | version without error bars #########################################
figname <- "LH-GNP5-PU4_amplitude_sweep"

## Plot tiff
tiff(paste(outfolder, figname, ".tiff", sep=""),
     width = 6.5, height = 4.5, units = "cm", compression = "lzw", res = 800, pointsize = 8, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_df, aes(x = 100*shear_strain, y = storage_mod, color = "G'", shape = "G'")) +
  geom_point(size = .75) + #geom_point(size = 3)
  geom_point(aes(x = 100*shear_strain, y = loss_mod, color = "G''", shape = "G''"), size = 0.75) +
  scale_x_log10(labels = c(0.01, 0.1, 1, 10, 100), breaks = c(0.01, 0.1, 1, 10, 100), limits = c(0.01, 100), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  scale_y_log10(labels = c(10, 100, 1000, 10000, "100000"), breaks = c(10, 100, 1000, 10000, 100000), limits = c(10, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  annotation_logticks(sides = "trbl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear strain \\[%\\]")) +
  ylab(TeX("G' G'' \\[Pa\\]")) +
  scale_shape_manual(values = c(19, 15, 17, 18, 21, 22, 23, 24, 25), 
                     name = "", # without the name argument in both scale types, there will be two legends (one for color, one for shape)
                     breaks = c("G'", "G''"),
                     labels = c("G'", "G''"))+ # guide = FALSE
  scale_colour_manual(values=cbPalVivid, 
                      name = "",
                      breaks = c("G'", "G''"),
                      labels = c("G'", "G''")) + # breaks are not required, otherwise it will just copy them from the color names
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

## Plot pdf
pdf(paste(outfolder, figname, ".pdf", sep=""),
    width = 6.5*cm2inch, height = 4.5*cm2inch)
viscosity_plot <-  ggplot(data = rheo_df, aes(x = 100*shear_strain, y = storage_mod, color = "G'", shape = "G'")) +
  geom_point(size = .75) + #geom_point(size = 3)
  geom_point(aes(x = 100*shear_strain, y = loss_mod, color = "G''", shape = "G''"), size = 0.75) +
  scale_x_log10(labels = c(0.01, 0.1, 1, 10, 100), breaks = c(0.01, 0.1, 1, 10, 100), limits = c(0.01, 100), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  scale_y_log10(labels = c(10, 100, 1000, 10000, "100000"), breaks = c(10, 100, 1000, 10000, 100000), limits = c(10, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  annotation_logticks(sides = "trbl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear strain \\[%\\]")) +
  ylab(TeX("G' G'' \\[Pa\\]")) +
  scale_shape_manual(values = c(19, 15, 17, 18, 21, 22, 23, 24, 25), 
                     name = "", # without the name argument in both scale types, there will be two legends (one for color, one for shape)
                     breaks = c("G'", "G''"),
                     labels = c("G'", "G''"))+ # guide = FALSE
  scale_colour_manual(values=cbPalVivid, 
                      name = "",
                      breaks = c("G'", "G''"),
                      labels = c("G'", "G''")) + # breaks are not required, otherwise it will just copy them from the color names
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()


###############  Plotting loss factors | version without error bars #########################################
figname <- "CV-GNP5-PU9_loss_factor_amplitude_sweep"

## Plot tiff
tiff(paste(outfolder, figname, ".tiff", sep=""),
     width = 6.5, height = 4.5, units = "cm", compression = "lzw", res = 800, pointsize = 8, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_df, aes(x = 100*shear_strain, y = loss_factor, color = "G'", shape = "G'")) +
  geom_point(size = .75) + #geom_point(size = 3)
  scale_x_log10(labels = c(0.01, 0.1, 1, 10, 100), breaks = c(0.01, 0.1, 1, 10, 100), limits = c(0.01, 100), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(10, 100, 1000, 10000, "100000"), breaks = c(10, 100, 1000, 10000, 100000), limits = c(10, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  ylim(0, 5) +
  annotation_logticks(sides = "tb", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear strain \\[%\\]")) +
  ylab(TeX("Loss factor")) +
  scale_shape_manual(values = c(19, 15, 17, 18, 21, 22, 23, 24, 25), 
                     name = "", # without the name argument in both scale types, there will be two legends (one for color, one for shape)
                     breaks = c("G'", "G''"),
                     labels = c("G'", "G''"),
                     guide = FALSE)+ # guide = FALSE
  scale_colour_manual(values=cbPalVivid, 
                      name = "",
                      breaks = c("G'", "G''"),
                      labels = c("G'", "G''"),
                      guide = FALSE) + # breaks are not required, otherwise it will just copy them from the color names
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.25),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

## Plot pdf
pdf(paste(outfolder, figname, ".pdf", sep=""),
    width = 6.5*cm2inch, height = 4.5*cm2inch)
viscosity_plot <-  ggplot(data = rheo_df, aes(x = 100*shear_strain, y = loss_factor, color = "G'", shape = "G'")) +
  geom_point(size = .75) + #geom_point(size = 3)
  scale_x_log10(labels = c(0.01, 0.1, 1, 10, 100), breaks = c(0.01, 0.1, 1, 10, 100), limits = c(0.01, 100), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(10, 100, 1000, 10000, "100000"), breaks = c(10, 100, 1000, 10000, 100000), limits = c(10, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  ylim(0, 5) +
  annotation_logticks(sides = "tb", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear strain \\[%\\]")) +
  ylab(TeX("Loss factor")) +
  scale_shape_manual(values = c(19, 15, 17, 18, 21, 22, 23, 24, 25), 
                     name = "", # without the name argument in both scale types, there will be two legends (one for color, one for shape)
                     breaks = c("G'", "G''"),
                     labels = c("G'", "G''"),
                     guide = FALSE)+ # guide = FALSE
  scale_colour_manual(values=cbPalVivid, 
                      name = "",
                      breaks = c("G'", "G''"),
                      labels = c("G'", "G''"),
                      guide = FALSE) + # breaks are not required, otherwise it will just copy them from the color names
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.25),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()
